
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"
#include "newRandom.h"

static mb elem, elemDiff, elemMin;
static int n, *row, *col;

using namespace std;
static mb randTerm()
{
    mb  term;
    
    mbRandom(term, elemDiff);
    term = term + elemMin;
    return term;
    
}/* randTerm */

static void shuffle(int *z)
{
    int     i, r, temp;
    
    for(i=0;i<n;++i)
    {
        r = rand() % n;
        temp = z[i];
        z[i] = z[r];
        z[r] = temp;
    }
    
}/* shuffle */

static bool isNeg()
{
    int     z;
    
    z = rand() % 2;
    if(!z)
        return true;
    else
        return false;
    
}/* isNeg */

static void myCase0(matq& M)
{
    int     i, j, iMax, jMax;
    mb      termMax, f, offset;
    
    f = 100;
    termMax = 2;
    shuffle(row);
    iMax = rand() % n;
    for(i=0;i<iMax;++i)
    {
        shuffle(col);
        jMax = rand() % n;
        for(j=0;j<jMax;++j)
        {
            mbRandom(offset, termMax);
            offset = offset + 1;
            if(isNeg)
                offset = -offset;
            M.array[row[i]][col[j]] = M.array[row[i]][col[j]] + offset;
        }
    }
    
}/* myCase0 */

static void myCase1(matq& M)
{
    int     i, j, iMax, jMax;
    mb      termMax, f, offset;
    
    f = 10000;
    termMax = 10;
    shuffle(row);
    iMax = rand() % n;
    for(i=0;i<iMax;++i)
    {
        shuffle(col);
        jMax = rand() % n;
        for(j=0;j<jMax;++j)
        {
            mbRandom(offset, termMax);
            offset = offset + 1;
            if(isNeg)
                offset = -offset;
            M.array[row[i]][col[j]] = M.array[row[i]][col[j]] + offset;
        }
    }
    
}/* myCase1 */

static void myCase2(matq& M)
{
    int     i, j, iMax, jMax;
    mb      termMax, f, offset;
    
    //f = 100;
    termMax = 100;
    shuffle(row);
    iMax = rand() % n;
    for(i=0;i<iMax;++i)
    {
        shuffle(col);
        jMax = rand() % n;
        for(j=0;j<jMax;++j)
        {
            mbRandom(offset, termMax);
            offset = offset + 1;
            if(isNeg)
                offset = -offset;
            M.array[row[i]][col[j]] = M.array[row[i]][col[j]] + offset;
        }
    }
    
}/* myCase2 */

int main (int argc, char * const argv[])
{
    matq        M, Mt;
    mb          N="23188567757135730773"; // to be factored
    // = 8201246737 * 2827444229
    int         joltNum, maxJolts=10;
    int         caseNum, numCases=3, tries, triesMax=5000;
    bf          det;
    mb          diff, diffLast; // to go to zero
    mb          term, elemMax, one="1", f="11";
    int         i, j;
    
    n = 4;
    InitArray(0);
    srand (time(NULL));
    row = (int*)malloc(n*sizeof(int));
    col = (int*)malloc(n*sizeof(int));
    for(i=0;i<n;++i)
        row[i] = col[i] = i;
    
    elem = nthRoot(300.*N, n); // 300 best?  11 digits
    //cout << elem << endl;
    //return 0;
    elemMin = elem - elem/f;
    elemMax = elem + elem/f;
    elemDiff = elemMax - elemMin;
    
    init(M, n, n);
    
    for(joltNum=0;joltNum<maxJolts;++joltNum)
    {
        cout << "jolt " << joltNum+1 << endl;
        for(i=0;i<M.nr;++i)
            for(j=0;j<M.nc;++j)
                M.array[i][j] = randTerm();
            
        det = determinant(M);
        diffLast = abs(N - det.num);
        //cout << "diffLast = " << diffLast << endl;
        // gen random caseNum
        tries = 0;
        while(tries<triesMax)
        {
            Mt = M;
            caseNum = rand() % numCases;
            switch(caseNum)
            {
                case 0: myCase0(M);
                    break;
                case 1: myCase1(M);
                    break;
                case 2: myCase2(M);
                    break;
                default: ;
            }
            det = determinant(M);
            diff = abs(N - det.num);
            if(!diff)
            {
                cout << endl << "M = " << M << endl;
                return 0;
            }
            //cout << "diff = " << diff << endl;
            if(diff<diffLast)
            {
                diffLast = diff;
                tries = 0;
                //cout << diff << "            \r" << flush;
            }
            else
            {
                M = Mt;
                tries++;
            }
            if(tries==triesMax)
                cout << diffLast << endl;
        }
        
    }
    
    return 0;
}
/*
 std::cout << "will not see this\rwill see this" << std::flush;
 std::cout << std::endl; // all done
 */
